// Auto-generated file - DO NOT EDIT manually
// Generated by tools/generate_cie_luts.py
//
// CIE 1931 lightness lookup tables optimized for different bit depths
//
// This file contains pre-computed lookup tables that map 8-bit RGB input values (0-255)
// to perceptually-linear output values at various bit depths. Native bit-depth lookup
// tables eliminate runtime conversion overhead and improve gradient quality.
//
// Based on:
//   - https://ledshield.wordpress.com/2012/11/13/led-brightness-to-your-eye-gamma-correction-no/
//   - https://gist.github.com/mathiasvr/19ce1d7b6caeab230934080ae1f1380e
//
// Formula: CIE 1931 lightness curve
//   For L ≤ 8:    Y = L / 902.3
//   For L > 8:    Y = ((L + 16) / 116)³
//   Where L = input brightness (0-100), Y = output luminance (0-1)

#pragma once

#ifndef NO_CIE1931

#include <stdint.h>


#if !defined(PIXEL_COLOR_DEPTH_BITS) || PIXEL_COLOR_DEPTH_BITS == 4
// 4-bit CIE 1931 lookup table
// Maps 8-bit input (0-255) to 4-bit output (0-15)
static const uint8_t lumConvTab_4bit[256] = {
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     0,     0,     0,     0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
      1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
      1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
      1,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     3,     3,     3,     3,     3,     3,
      3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,     4,     4,
      4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,     5,     5,
      5,     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,     6,     6,     6,     6,     6,
      6,     6,     6,     6,     6,     6,     6,     6,     7,     7,     7,     7,     7,     7,     7,     7,
      7,     7,     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,     9,     9,     9,     9,
      9,     9,     9,     9,     9,     9,    10,    10,    10,    10,    10,    10,    10,    10,    11,    11,
     11,    11,    11,    11,    11,    11,    12,    12,    12,    12,    12,    12,    12,    12,    13,    13,
     13,    13,    13,    13,    13,    14,    14,    14,    14,    14,    14,    14,    15,    15,    15,    15,
};
#endif

#if !defined(PIXEL_COLOR_DEPTH_BITS) || PIXEL_COLOR_DEPTH_BITS == 6
// 6-bit CIE 1931 lookup table
// Maps 8-bit input (0-255) to 6-bit output (0-63)
static const uint8_t lumConvTab_6bit[256] = {
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      0,     0,     0,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
      1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
      2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,     3,     3,     3,
      3,     3,     3,     3,     3,     3,     3,     3,     3,     4,     4,     4,     4,     4,     4,     4,
      4,     4,     5,     5,     5,     5,     5,     5,     5,     5,     5,     6,     6,     6,     6,     6,
      6,     6,     7,     7,     7,     7,     7,     7,     7,     8,     8,     8,     8,     8,     8,     9,
      9,     9,     9,     9,     9,    10,    10,    10,    10,    10,    11,    11,    11,    11,    11,    12,
     12,    12,    12,    12,    13,    13,    13,    13,    13,    14,    14,    14,    14,    15,    15,    15,
     15,    16,    16,    16,    16,    17,    17,    17,    17,    18,    18,    18,    19,    19,    19,    19,
     20,    20,    20,    21,    21,    21,    22,    22,    22,    22,    23,    23,    23,    24,    24,    24,
     25,    25,    25,    26,    26,    27,    27,    27,    28,    28,    28,    29,    29,    30,    30,    30,
     31,    31,    32,    32,    32,    33,    33,    34,    34,    34,    35,    35,    36,    36,    37,    37,
     37,    38,    38,    39,    39,    40,    40,    41,    41,    42,    42,    43,    43,    44,    44,    45,
     45,    46,    46,    47,    47,    48,    48,    49,    49,    50,    51,    51,    52,    52,    53,    53,
     54,    54,    55,    56,    56,    57,    57,    58,    59,    59,    60,    60,    61,    62,    62,    63,
};
#endif

#if !defined(PIXEL_COLOR_DEPTH_BITS) || PIXEL_COLOR_DEPTH_BITS == 7
// 7-bit CIE 1931 lookup table
// Maps 8-bit input (0-255) to 7-bit output (0-127)
static const uint8_t lumConvTab_7bit[256] = {
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     1,     1,     1,     1,     1,     1,
      1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,     2,     2,     2,     2,     2,
      2,     2,     2,     2,     2,     2,     2,     2,     3,     3,     3,     3,     3,     3,     3,     3,
      3,     4,     4,     4,     4,     4,     4,     4,     4,     5,     5,     5,     5,     5,     5,     5,
      6,     6,     6,     6,     6,     6,     7,     7,     7,     7,     7,     8,     8,     8,     8,     8,
      9,     9,     9,     9,    10,    10,    10,    10,    10,    11,    11,    11,    11,    12,    12,    12,
     13,    13,    13,    13,    14,    14,    14,    15,    15,    15,    16,    16,    16,    16,    17,    17,
     18,    18,    18,    19,    19,    19,    20,    20,    20,    21,    21,    22,    22,    22,    23,    23,
     24,    24,    24,    25,    25,    26,    26,    27,    27,    28,    28,    29,    29,    29,    30,    30,
     31,    31,    32,    33,    33,    34,    34,    35,    35,    36,    36,    37,    37,    38,    39,    39,
     40,    40,    41,    42,    42,    43,    43,    44,    45,    45,    46,    47,    47,    48,    49,    49,
     50,    51,    51,    52,    53,    54,    54,    55,    56,    56,    57,    58,    59,    60,    60,    61,
     62,    63,    64,    64,    65,    66,    67,    68,    69,    69,    70,    71,    72,    73,    74,    75,
     76,    76,    77,    78,    79,    80,    81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
     91,    92,    93,    94,    95,    96,    97,    99,   100,   101,   102,   103,   104,   105,   106,   107,
    109,   110,   111,   112,   113,   115,   116,   117,   118,   119,   121,   122,   123,   124,   126,   127,
};
#endif

#if !defined(PIXEL_COLOR_DEPTH_BITS) || PIXEL_COLOR_DEPTH_BITS == 8
// 8-bit CIE 1931 lookup table
// Maps 8-bit input (0-255) to 8-bit output (0-255)
static const uint8_t lumConvTab_8bit[256] = {
      0,     0,     0,     0,     0,     1,     1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
      2,     2,     2,     2,     2,     2,     2,     3,     3,     3,     3,     3,     3,     3,     3,     4,
      4,     4,     4,     4,     4,     5,     5,     5,     5,     5,     6,     6,     6,     6,     6,     7,
      7,     7,     7,     8,     8,     8,     8,     9,     9,     9,    10,    10,    10,    10,    11,    11,
     11,    12,    12,    12,    13,    13,    13,    14,    14,    15,    15,    15,    16,    16,    17,    17,
     17,    18,    18,    19,    19,    20,    20,    21,    21,    22,    22,    23,    23,    24,    24,    25,
     25,    26,    26,    27,    28,    28,    29,    29,    30,    31,    31,    32,    32,    33,    34,    34,
     35,    36,    37,    37,    38,    39,    39,    40,    41,    42,    43,    43,    44,    45,    46,    47,
     47,    48,    49,    50,    51,    52,    53,    54,    54,    55,    56,    57,    58,    59,    60,    61,
     62,    63,    64,    65,    66,    67,    68,    70,    71,    72,    73,    74,    75,    76,    77,    79,
     80,    81,    82,    83,    85,    86,    87,    88,    90,    91,    92,    94,    95,    96,    98,    99,
    100,   102,   103,   105,   106,   108,   109,   110,   112,   113,   115,   116,   118,   120,   121,   123,
    124,   126,   128,   129,   131,   132,   134,   136,   138,   139,   141,   143,   145,   146,   148,   150,
    152,   154,   155,   157,   159,   161,   163,   165,   167,   169,   171,   173,   175,   177,   179,   181,
    183,   185,   187,   189,   191,   193,   196,   198,   200,   202,   204,   207,   209,   211,   214,   216,
    218,   220,   223,   225,   228,   230,   232,   235,   237,   240,   242,   245,   247,   250,   252,   255,
};
#endif

#if !defined(PIXEL_COLOR_DEPTH_BITS) || PIXEL_COLOR_DEPTH_BITS == 10
// 10-bit CIE 1931 lookup table
// Maps 8-bit input (0-255) to 10-bit output (0-1023)
static const uint16_t lumConvTab_10bit[256] = {
      0,     0,     1,     1,     2,     2,     3,     3,     4,     4,     4,     5,     5,     6,     6,     7,
      7,     8,     8,     8,     9,     9,    10,    10,    11,    11,    12,    12,    13,    13,    14,    15,
     15,    16,    17,    17,    18,    19,    19,    20,    21,    22,    22,    23,    24,    25,    26,    27,
     28,    29,    30,    31,    32,    33,    34,    35,    36,    37,    38,    39,    40,    42,    43,    44,
     45,    47,    48,    50,    51,    52,    54,    55,    57,    58,    60,    61,    63,    65,    66,    68,
     70,    71,    73,    75,    77,    79,    81,    83,    84,    86,    88,    90,    93,    95,    97,    99,
    101,   103,   106,   108,   110,   113,   115,   118,   120,   123,   125,   128,   130,   133,   136,   138,
    141,   144,   147,   149,   152,   155,   158,   161,   164,   167,   171,   174,   177,   180,   183,   187,
    190,   194,   197,   200,   204,   208,   211,   215,   218,   222,   226,   230,   234,   237,   241,   245,
    249,   254,   258,   262,   266,   270,   275,   279,   283,   288,   292,   297,   301,   306,   311,   315,
    320,   325,   330,   335,   340,   345,   350,   355,   360,   365,   370,   376,   381,   386,   392,   397,
    403,   408,   414,   420,   425,   431,   437,   443,   449,   455,   461,   467,   473,   480,   486,   492,
    499,   505,   512,   518,   525,   532,   538,   545,   552,   559,   566,   573,   580,   587,   594,   601,
    609,   616,   624,   631,   639,   646,   654,   662,   669,   677,   685,   693,   701,   709,   717,   726,
    734,   742,   751,   759,   768,   776,   785,   794,   802,   811,   820,   829,   838,   847,   857,   866,
    875,   885,   894,   903,   913,   923,   932,   942,   952,   962,   972,   982,   992,  1002,  1013,  1023,
};
#endif

#if !defined(PIXEL_COLOR_DEPTH_BITS) || PIXEL_COLOR_DEPTH_BITS == 12
// 12-bit CIE 1931 lookup table
// Maps 8-bit input (0-255) to 12-bit output (0-4095)
static const uint16_t lumConvTab_12bit[256] = {
      0,     2,     4,     5,     7,     9,    11,    12,    14,    16,    18,    20,    21,    23,    25,    27,
     28,    30,    32,    34,    36,    37,    39,    41,    43,    45,    47,    49,    52,    54,    56,    59,
     61,    64,    66,    69,    72,    75,    77,    80,    83,    87,    90,    93,    96,   100,   103,   107,
    111,   115,   118,   122,   126,   131,   135,   139,   144,   148,   153,   157,   162,   167,   172,   177,
    182,   187,   193,   198,   204,   209,   215,   221,   227,   233,   239,   246,   252,   259,   265,   272,
    279,   286,   293,   300,   308,   315,   323,   330,   338,   346,   354,   362,   371,   379,   388,   396,
    405,   414,   423,   432,   442,   451,   461,   470,   480,   490,   501,   511,   521,   532,   543,   553,
    564,   576,   587,   598,   610,   622,   634,   646,   658,   670,   683,   695,   708,   721,   734,   748,
    761,   775,   788,   802,   816,   831,   845,   860,   874,   889,   904,   920,   935,   951,   966,   982,
    999,  1015,  1031,  1048,  1065,  1082,  1099,  1116,  1134,  1152,  1170,  1188,  1206,  1224,  1243,  1262,
   1281,  1300,  1320,  1339,  1359,  1379,  1399,  1420,  1440,  1461,  1482,  1503,  1525,  1546,  1568,  1590,
   1612,  1635,  1657,  1680,  1703,  1726,  1750,  1774,  1797,  1822,  1846,  1870,  1895,  1920,  1945,  1971,
   1996,  2022,  2048,  2074,  2101,  2128,  2155,  2182,  2209,  2237,  2265,  2293,  2321,  2350,  2378,  2407,
   2437,  2466,  2496,  2526,  2556,  2587,  2617,  2648,  2679,  2711,  2743,  2774,  2807,  2839,  2872,  2905,
   2938,  2971,  3005,  3039,  3073,  3107,  3142,  3177,  3212,  3248,  3283,  3319,  3356,  3392,  3429,  3466,
   3503,  3541,  3578,  3617,  3655,  3694,  3732,  3772,  3811,  3851,  3891,  3931,  3972,  4012,  4054,  4095,
};
#endif

// ============================================================================
// Compile-time selection of appropriate LUT based on PIXEL_COLOR_DEPTH_BITS
// ============================================================================

#if !defined(PIXEL_COLOR_DEPTH_BITS)
  #define PIXEL_COLOR_DEPTH_BITS 8
#endif

#if PIXEL_COLOR_DEPTH_BITS == 4
  #define lumConvTab lumConvTab_4bit
  #define LUT_NATIVE_BIT_DEPTH 1
#elif PIXEL_COLOR_DEPTH_BITS == 6
  #define lumConvTab lumConvTab_6bit
  #define LUT_NATIVE_BIT_DEPTH 1
#elif PIXEL_COLOR_DEPTH_BITS == 7
  #define lumConvTab lumConvTab_7bit
  #define LUT_NATIVE_BIT_DEPTH 1
#elif PIXEL_COLOR_DEPTH_BITS == 8
  #define lumConvTab lumConvTab_8bit
  #define LUT_NATIVE_BIT_DEPTH 1
#elif PIXEL_COLOR_DEPTH_BITS == 10
  #define lumConvTab lumConvTab_10bit
  #define LUT_NATIVE_BIT_DEPTH 1
#elif PIXEL_COLOR_DEPTH_BITS == 12
  #define lumConvTab lumConvTab_12bit
  #define LUT_NATIVE_BIT_DEPTH 1
#else
  // Fallback for non-standard bit depths (9, 11, etc.)
  // Uses 12-bit LUT with runtime shift+round conversion
  #define lumConvTab lumConvTab_12bit
  #define LUT_NATIVE_BIT_DEPTH 0
  #warning "Using non-native CIE LUT bit depth - using 12-bit LUT with runtime conversion"
#endif

#endif // NO_CIE1931
